/***********************************************************
*                        DCF-clock                         *
*            a tiny DCF controlled digital clock           *
*                                                          *
*           by Frank Goetze  -  www.embedded-os.de         *
************************************************************
* Permission to use, copy, modify, and distribute this     *
* software in source and binary forms and its              *
* documentation for any purpose and without fee is hereby  *
* granted, provided that the above authors notice appear   *
* in all copies and that both that authors notice and this *
* permission notice appear in supporting documentation.    *
*                                                          *
* THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND   *
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT    *
* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY    *
* AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.     *
* IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,  *
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR             *
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,    *
* PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF     *
* USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER *
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN        *
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING           *
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE   *
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY *
* OF SUCH DAMAGE.                                          *
************************************************************
*              clock_Adafruit_Feather_M0.h                 *
*   the board support package for the Adafruit Feather M0  *
************************************************************
* Revision-Info:                                           *
*                                                          *
* 1.00a     first alpa-release                             *
*                                                          *
***********************************************************/

#define DCF77            // define DCF or the UART for HKW module will be used

//#define OLED_SPI         // using 2.42" OLED display 128x64
#define OLED_I2C         // using 0.96" / 1.3" OLED display 128x64


void BSP_delay(unsigned int dlyTicks);
void SetupMainClock(void);

void ADC_Init(void);
float ADC_VBATread(void);

#ifdef OLED_SPI
 void SPI_Init(void);
 void SPI_write(unsigned char data);
 void SPI_CS_en(void);
 void SPI_CS_dis(void);
 void SPI_DC_en(void);
 void SPI_DC_dis(void);
 void SPI_RES_en(void);
 void SPI_RES_dis(void);
#elif defined OLED_I2C
 void I2C_Init(void);
 void I2C_send(unsigned char *data, unsigned short len);
#else
 #warning "unknown display type!"
#endif

#ifdef DCF77
 void DCF_Init(void);
 unsigned int DCF_in_Get(void);
 void DCF_Enable(void);
 void DCF_Disable(void);
#else
 void UART_Init(void);
 void write_uart_data(unsigned char data);
 unsigned char read_uart_data(void);
#endif

void Button_Init(void);
unsigned int Button_Get(void);

void LED_Init(void);
void LED_On(void);
void LED_Off(void);
void LED_Toggle(void);

void BSP_Init(void);

/************************* END ****************************/
