/***********************************************************
*                        DCF-clock                         *
*            a tiny DCF controlled digital clock           *
*                                                          *
*           by Frank Goetze  -  www.embedded-os.de         *
************************************************************
* Permission to use, copy, modify, and distribute this     *
* software in source and binary forms and its              *
* documentation for any purpose and without fee is hereby  *
* granted, provided that the above authors notice appear   *
* in all copies and that both that authors notice and this *
* permission notice appear in supporting documentation.    *
*                                                          *
* THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND   *
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT    *
* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY    *
* AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.     *
* IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,  *
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR             *
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,    *
* PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF     *
* USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER *
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN        *
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING           *
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE   *
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY *
* OF SUCH DAMAGE.                                          *
************************************************************
*                    DCF77_decoder.c                       *
*      the collector and decoder of the DCF77 signal       *
************************************************************
* Revision-Info:                                           *
*                                                          *
* 1.00a     first alpa-release                             *
*                                                          *
***********************************************************/

/*
 * After playing with 
 * - 1 pcs of the HKW DCF77 module FMD01021R and his dead 
 *   after 3 days and
 * - 2 pcs of the HKW DCF77 module FMD01031R and the dead 
 *   of both at the time I want use them (or receiving dead ?)
 * I was stoping my work on this modules and switching to 
 * other simple DCF77 receiver modules without it's own decoder.
 * For this simple modules (Pollin as example) here the 
 * collector & decoder.
 */

#include "../inc/clock_time.h"
#include "../BSP/clock_Adafruit_Feather_M0.h"
#include <string.h>

extern unsigned char volatile rx_det;

static time_t  dcf_time = {(unsigned char)-1};

static struct {
    unsigned char  bits[8];       // for bits 0...59
    unsigned char  bitno;
    unsigned char  parity;
    unsigned char  sync;
    unsigned short high_cnt;
    unsigned short low_cnt;
} dcf = {{0,0,0,0,0,0,0,0},0,0,0,0,0};

static struct {
    unsigned char valid;
    unsigned char bits[8];
} dcf_sync = {0,{0,0,0,0,0,0,0,0}};

static void DCF_copyTime(void)             // running in interrupt mode
{
    unsigned char i;
    for (i = 0; i < 8; i++) dcf_sync.bits[i] = dcf.bits[i];
    dcf_sync.valid = 1;
}

static void DCF_readTime(void)             // running in application mode - should be optimized !?
{
    dcf_time.second = 0;
    dcf_time.minute = 0;
    if (dcf_sync.bits[21/8] & (0x80 >> (21%8))) dcf_time.minute += 1;
    if (dcf_sync.bits[22/8] & (0x80 >> (22%8))) dcf_time.minute += 2;
    if (dcf_sync.bits[23/8] & (0x80 >> (23%8))) dcf_time.minute += 4;
    if (dcf_sync.bits[24/8] & (0x80 >> (24%8))) dcf_time.minute += 8;
    if (dcf_sync.bits[25/8] & (0x80 >> (25%8))) dcf_time.minute += 10;
    if (dcf_sync.bits[26/8] & (0x80 >> (26%8))) dcf_time.minute += 20;
    if (dcf_sync.bits[27/8] & (0x80 >> (27%8))) dcf_time.minute += 40;
    dcf_time.hour = 0;
    if (dcf_sync.bits[29/8] & (0x80 >> (29%8))) dcf_time.hour += 1;
    if (dcf_sync.bits[30/8] & (0x80 >> (30%8))) dcf_time.hour += 2;
    if (dcf_sync.bits[31/8] & (0x80 >> (31%8))) dcf_time.hour += 4;
    if (dcf_sync.bits[32/8] & (0x80 >> (32%8))) dcf_time.hour += 8;
    if (dcf_sync.bits[33/8] & (0x80 >> (33%8))) dcf_time.hour += 10;
    if (dcf_sync.bits[34/8] & (0x80 >> (34%8))) dcf_time.hour += 20;
    dcf_time.day = 0;
    if (dcf_sync.bits[36/8] & (0x80 >> (36%8))) dcf_time.day += 1;
    if (dcf_sync.bits[37/8] & (0x80 >> (37%8))) dcf_time.day += 2;
    if (dcf_sync.bits[38/8] & (0x80 >> (38%8))) dcf_time.day += 4;
    if (dcf_sync.bits[39/8] & (0x80 >> (39%8))) dcf_time.day += 8;
    if (dcf_sync.bits[40/8] & (0x80 >> (40%8))) dcf_time.day += 10;
    if (dcf_sync.bits[41/8] & (0x80 >> (41%8))) dcf_time.day += 20;
    dcf_time.wday = 0;
    if (dcf_sync.bits[42/8] & (0x80 >> (42%8))) dcf_time.wday += 1;
    if (dcf_sync.bits[43/8] & (0x80 >> (43%8))) dcf_time.wday += 2;
    if (dcf_sync.bits[44/8] & (0x80 >> (44%8))) dcf_time.wday += 4;
    dcf_time.month = 0;
    if (dcf_sync.bits[45/8] & (0x80 >> (45%8))) dcf_time.month += 1;
    if (dcf_sync.bits[46/8] & (0x80 >> (46%8))) dcf_time.month += 2;
    if (dcf_sync.bits[47/8] & (0x80 >> (47%8))) dcf_time.month += 4;
    if (dcf_sync.bits[48/8] & (0x80 >> (48%8))) dcf_time.month += 8;
    if (dcf_sync.bits[49/8] & (0x80 >> (49%8))) dcf_time.month += 10;
    dcf_time.year = 0;
    if (dcf_sync.bits[50/8] & (0x80 >> (50%8))) dcf_time.year += 1;
    if (dcf_sync.bits[51/8] & (0x80 >> (51%8))) dcf_time.year += 2;
    if (dcf_sync.bits[52/8] & (0x80 >> (52%8))) dcf_time.year += 4;
    if (dcf_sync.bits[53/8] & (0x80 >> (53%8))) dcf_time.year += 8;
    if (dcf_sync.bits[54/8] & (0x80 >> (54%8))) dcf_time.year += 10;
    if (dcf_sync.bits[55/8] & (0x80 >> (55%8))) dcf_time.year += 20;
    if (dcf_sync.bits[56/8] & (0x80 >> (56%8))) dcf_time.year += 40;
    if (dcf_sync.bits[57/8] & (0x80 >> (57%8))) dcf_time.year += 80;
    dcf_sync.valid = 0;
}

void DCF_sync_Time(time_t *rtc_time)       // running in application mode
{
    if (dcf_sync.valid != 0) {
        DCF_readTime();
        if (((*rtc_time).second > 50) || ((*rtc_time).newminute != 0)) dcf_time.newminute = 1;
        if (((*rtc_time).minute > 50) || (dcf_time.minute == 0) || ((*rtc_time).newhour != 0)) dcf_time.newhour = 1;
        memcpy((void *)rtc_time, (void *)&dcf_time, sizeof(time_t));
    }
}


/*
 *                 +----------++          +++           ++---------------+++----+
 *                 |          ||          |||           ||               |||    |
 * XX--------------+          ++----------+++-----------++               +++    +---------
 *     > 1.7s sync      '0' filter       filter       filter     '1'    filter 
*/
// --- timing definitions in 10ms poll ticks ---
#define DCF_SIGNAL_FILTER_WIDTH     4
#define DCF_SIGNAL_TOLERANCE        5
#define DCF_SIGNAL_1sLOW           70
#define DCF_SIGNAL_2sLOW          170
#define DCF_SIGNAL_0BIT            10
#define DCF_SIGNAL_1BIT            20

void DCF_Handler_time(void)                // running in interrupt mode - called every 10ms
{
    unsigned char b = 0;

    if (DCF_in_Get() != 0) {
        dcf.high_cnt++;
        if (dcf.low_cnt > DCF_SIGNAL_2sLOW) {
            if ((dcf.sync != 0) && (dcf.bitno == 59) && (dcf.bits[20/8] & (0x80 >> (20%8)))) {
                DCF_copyTime();
                rx_det   = 2;
            } else {
                rx_det   = 1;
            }
            dcf.bitno     = 0;
            dcf.parity    = 0;
            dcf.high_cnt  = 1;
            dcf.low_cnt   = 0;
            dcf.sync      = 1;
        } else if (dcf.low_cnt > DCF_SIGNAL_1sLOW) {
            dcf.low_cnt  = 0;
        } else if ((dcf.low_cnt != 0) && (dcf.low_cnt < DCF_SIGNAL_FILTER_WIDTH)) {
            dcf.high_cnt += dcf.low_cnt;
            dcf.low_cnt  = 0;
        }
    } else {
        dcf.low_cnt++;
        if ((dcf.low_cnt > DCF_SIGNAL_FILTER_WIDTH) && (dcf.high_cnt != 0)) {
            if (dcf.high_cnt < DCF_SIGNAL_FILTER_WIDTH) {
                dcf.low_cnt += dcf.high_cnt;
                dcf.high_cnt = 0;
            } else {
                if (dcf.sync != 0) {
                    if ((dcf.high_cnt > (DCF_SIGNAL_1BIT - DCF_SIGNAL_TOLERANCE)) && (dcf.high_cnt < (DCF_SIGNAL_1BIT + DCF_SIGNAL_TOLERANCE))) b = 1;
                    else if ((dcf.high_cnt > (DCF_SIGNAL_0BIT - DCF_SIGNAL_TOLERANCE)) && (dcf.high_cnt < (DCF_SIGNAL_0BIT + DCF_SIGNAL_TOLERANCE))) b = 0;
                    else {
                        dcf.sync = 0;
                        rx_det   = 0;
                        return;
                    }
                    if ((dcf.bitno == 28) || (dcf.bitno == 35) || (dcf.bitno == 58)) {
                        if (b != (dcf.parity & 1)) {
                            dcf.sync = 0;
                            rx_det   = 0;
                            return;
                        }
                        dcf.parity = 0;
                    } else if ((b != 0) && (dcf.bitno > 21)) dcf.parity++;
                    if (b != 0) { 
                        dcf.bits[dcf.bitno / 8] |=  (0x80 >> (dcf.bitno % 8)); dcf.bitno++;
                    } else {
                        dcf.bits[dcf.bitno / 8] &= ~(0x80 >> (dcf.bitno % 8)); dcf.bitno++;
                    }
                }
                dcf.high_cnt = 0;
            }
        }
    }
}

/************************* END ****************************/
