/***********************************************************
*                        DCF-clock                         *
*            a tiny DCF controlled digital clock           *
*                                                          *
*           by Frank Goetze  -  www.embedded-os.de         *
************************************************************
* Permission to use, copy, modify, and distribute this     *
* software in source and binary forms and its              *
* documentation for any purpose and without fee is hereby  *
* granted, provided that the above authors notice appear   *
* in all copies and that both that authors notice and this *
* permission notice appear in supporting documentation.    *
*                                                          *
* THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND   *
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT    *
* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY    *
* AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.     *
* IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,  *
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR             *
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,    *
* PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF     *
* USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER *
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN        *
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING           *
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE   *
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY *
* OF SUCH DAMAGE.                                          *
************************************************************
*                      clock_analog.c                      *
*      a classical analog clock using math functions       *
************************************************************
* analog clock bases on the arduino code from Giant.Metal.Robot            *
* at: http://giantmetalrobot.blogspot.de/2011/05/arduino-analog-clock.html *
************************************************************
* Revision-Info:                                           *
*                                                          *
* 1.00a     first alpa-release                             *
*                                                          *
***********************************************************/
#include <samd21.h>
#include <math.h>

#include "../inc/clock_time.h"
#include "../inc/clock_display.h"
#include "../display/OLED_SSD1306.h"
#include "../BSP/clock_Adafruit_Feather_M0.h"

extern time_t  time;
extern unsigned int sec100;
extern char datetime[16];

/**************** helping vars & code *********************/
static short tvx, tvy, tvradius, xs, ys, xm, ym, xh, yh, v = 0;

#define LMARK 4

#define T12_Symbol_X 7
#define T12_Symbol_Y 5
unsigned char const T12_Symbol[] = {
    0xFF,0xFF,0x00,0xFF,0xFF,0xFF,0xFF,
    0x00,0xFF,0x00,0x00,0x00,0x00,0xFF,
    0x00,0xFF,0x00,0xFF,0xFF,0xFF,0xFF,
    0x00,0xFF,0x00,0xFF,0x00,0x00,0x00,
    0x00,0xFF,0x00,0xFF,0xFF,0xFF,0xFF
};

#define T369_Symbol_X 4
#define T369_Symbol_Y 5
unsigned char const T3_Symbol[] = {
    0xFF,0xFF,0xFF,0xFF,
    0x00,0x00,0x00,0xFF,
    0xFF,0xFF,0xFF,0xFF,
    0x00,0x00,0x00,0xFF,
    0xFF,0xFF,0xFF,0xFF
};
unsigned char const T6_Symbol[] = {
    0xFF,0xFF,0xFF,0x00,
    0xFF,0x00,0x00,0x00,
    0xFF,0xFF,0xFF,0xFF,
    0xFF,0x00,0x00,0xFF,
    0xFF,0xFF,0xFF,0xFF
};
unsigned char const T9_Symbol[] = {
    0xFF,0xFF,0xFF,0xFF,
    0xFF,0x00,0x00,0xFF,
    0xFF,0xFF,0xFF,0xFF,
    0x00,0x00,0x00,0xFF,
    0x00,0xFF,0xFF,0xFF
};

/*
************************************************************
*                   init the analog clock                  *
************************************************************
*/
void clock_analog_init(void)
{
    float angle;
    short z, x2, y2;

    OLED_Clear(0);
    OLED_Line(0, DISPLAY_Y, 30, DISPLAY_Y, fgcolor);
    OLED_Line(DISPLAY_X - 30, DISPLAY_Y, DISPLAY_X, DISPLAY_Y, fgcolor);

    tvx      = OLED_MAX_X/2;
    tvy      = OLED_MAX_Y/2;
    tvradius = OLED_MAX_Y/2 - 1;
    OLED_Circle(tvx, tvy, tvradius, fgcolor);
    for(z = 0; z < 360; z += 30){
        angle = z ;
        angle = (angle / 57.29577951) ;
        x2 = (tvx + round(sin(angle) * tvradius));
        y2 = (tvy - round(cos(angle) * tvradius));
        xs = (tvx + round(sin(angle) * (tvradius - LMARK)));
        ys = (tvy - round(cos(angle) * (tvradius - LMARK)));
        OLED_Line(x2, y2, xs, ys, fgcolor);
    }
}

/*
************************************************************
*              next loop step of analog clock              *
************************************************************
*/
void clock_analog(void)
{
    unsigned short s = time.second;
    float angle;

    if (v != 0) {
        OLED_Line(tvx, tvy, xs, ys, bgcolor);
        OLED_Line(tvx, tvy, xm, ym, bgcolor);
        OLED_Line(tvx, tvy, xh, yh, bgcolor);
    }
    OLED_Image(tvx - 3,OLED_MAX_Y/2 - tvradius + LMARK + 2,(unsigned char *)T12_Symbol, T12_Symbol_X, T12_Symbol_Y, 0);
    OLED_Image(OLED_MAX_X/2 + tvradius - LMARK - 5,tvy - 2,(unsigned char *)T3_Symbol, T369_Symbol_X, T369_Symbol_Y, 0);
    OLED_Image(OLED_MAX_X/2 - tvradius + LMARK + 2,tvy - 2,(unsigned char *)T9_Symbol, T369_Symbol_X, T369_Symbol_Y, 0);
    OLED_Image(tvx - 1,OLED_MAX_Y/2 + tvradius - LMARK - 6,(unsigned char *)T6_Symbol, T369_Symbol_X, T369_Symbol_Y, 0);
    OLED_Circle(tvx, tvy, 2, fgcolor);
    angle = time.second * 6;
    angle = (angle / 57.29577951);
    xs = (tvx + round(sin(angle) * (tvradius - (LMARK + 1))));
    ys = (tvy - round(cos(angle) * (tvradius - (LMARK + 1))));
    OLED_Line(tvx, tvy, xs, ys, fgcolor);
    angle = time.minute * 6 ;
    angle = (angle / 57.29577951);
    xm = (tvx + round(sin(angle) * (tvradius - (LMARK + 6))));
    ym = (tvy - round(cos(angle) * (tvradius - (LMARK + 6))));
    OLED_Line(tvx, tvy, xm, ym, fgcolor);
    angle = time.hour * 30 + (int)((time.minute / 12) * 6);
    angle = (angle / 57.29577951);
    xh = (tvx + round(sin(angle) * (tvradius - (LMARK + 10))));
    yh = (tvy - round(cos(angle) * (tvradius - (LMARK + 10))));
    OLED_Line(tvx, tvy, xh, yh, fgcolor);
    OLED_Update(); v = 1;

    while ((s == time.second) && !(Button_Get())) {
        __NOP();
    }
}

/************************* END ****************************/
