/***********************************************************
*                        DCF-clock                         *
*            a tiny DCF controlled digital clock           *
*                                                          *
*           by Frank Goetze  -  www.embedded-os.de         *
************************************************************
* Permission to use, copy, modify, and distribute this     *
* software in source and binary forms and its              *
* documentation for any purpose and without fee is hereby  *
* granted, provided that the above authors notice appear   *
* in all copies and that both that authors notice and this *
* permission notice appear in supporting documentation.    *
*                                                          *
* THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND   *
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT    *
* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY    *
* AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.     *
* IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,  *
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR             *
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,    *
* PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF     *
* USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER *
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN        *
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING           *
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE   *
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY *
* OF SUCH DAMAGE.                                          *
************************************************************
*                     clock_circle.c                       *
*     a simple time plus secounds onto a circle as dot     *
************************************************************
* Revision-Info:                                           *
*                                                          *
* 1.00a     first alpa-release                             *
*                                                          *
***********************************************************/
#include <samd21.h>

#include "../inc/clock_time.h"
#include "../inc/clock_display.h"
#include "../display/OLED_SSD1306.h"
#include "../BSP/clock_Adafruit_Feather_M0.h"

extern time_t  time;
extern unsigned int sec100;
extern char datetime[16];

/**************** helping vars & code *********************/
typedef struct seconds {
    short x;
    short y;
} secounds_t;
const secounds_t sec_pixel[60] = {
    {0,30},{3,30},{6,30},{9,29},{12,28},{15,26},{18,24},{20,22},
    {22,20},{24,18},{26,15},{28,12},{29,9},{30,6},{30,3},
    {30,0},{30,-3},{30,-6},{29,-9},{28,-12},{26,-15},{24,-18},{22,-20},
    {20,-22},{18,-24},{15,-26},{12,-28},{9,-29},{6,-30},{3,-30},
    {0,-30},{-3,-30},{-6,-30},{-9,-29},{-12,-28},{-15,-26},{-18,-24},{-20,-22},
    {-22,-20},{-24,-18},{-26,-15},{-28,-12},{-29,-9},{-30,-6},{-30,-3},
    {-30,0},{-30,3},{-30,6},{-29,9},{-28,12},{-26,15},{-24,18},{-22,20},
    {-20,22},{-18,24},{-15,26},{-12,28},{-9,29},{-6,30},{-3,30}
};

struct {
    unsigned char x0;
    unsigned char y0;
    unsigned char msec;
    unsigned char csec;
} secCircle = {0,0,0,0};

static void setup_SecCircle(unsigned char x0, unsigned char y0, unsigned char mode)
{
    unsigned char i;

    if (mode != 0) {
        for (i = 0; i < 60; i++) OLED_setPixel((short)x0 + sec_pixel[i].x, (short)y0 - sec_pixel[i].y, 1);
    }
    secCircle.x0   = x0;
    secCircle.y0   = y0;
    secCircle.msec = mode;
}

static void update_SecCircle(unsigned char sec)
{
    if (secCircle.msec != 0) {
        OLED_Rect(secCircle.x0 + sec_pixel[secCircle.csec].x-1, secCircle.y0 - sec_pixel[secCircle.csec].y-1, secCircle.x0 + sec_pixel[secCircle.csec].x+1, secCircle.y0 - sec_pixel[secCircle.csec].y+1, 0);
        OLED_Rect(secCircle.x0 + sec_pixel[ sec].x-1, secCircle.y0 - sec_pixel[ sec].y-1, secCircle.x0 + sec_pixel[ sec].x+1, secCircle.y0 - sec_pixel[ sec].y+1, 1);
    } else {
        OLED_setPixel(secCircle.x0 + sec_pixel[secCircle.csec].x, secCircle.y0 - sec_pixel[secCircle.csec].y, 0);
        OLED_setPixel(secCircle.x0 + sec_pixel[ sec].x, secCircle.y0 - sec_pixel[ sec].y, 1);
    }
    secCircle.csec = sec;
}

static void t_itoa(unsigned char *buff, unsigned int value, unsigned int s_div, unsigned char mode)
{
    if ((value / s_div) > 0) { *buff++ = (value / s_div) + '0'; value %= s_div; }
    else if (mode != 0) *buff++ = '0';
    *buff++ = value + '0';
    *buff++ = 0;
}

/*
************************************************************
*                   init the circle clock                  *
************************************************************
*/
void clock_circle_init(void)
{
    OLED_Clear(0);
    OLED_Line(0, DISPLAY_Y, 30, DISPLAY_Y, fgcolor);
    OLED_Line(DISPLAY_X - 30, DISPLAY_Y, DISPLAY_X, DISPLAY_Y, fgcolor);
    setup_SecCircle(OLED_MAX_X/2, OLED_MAX_Y/2, 1);
}

/*
************************************************************
*              next loop step of circle clock              *
************************************************************
*/
void clock_circle(void)
{
    unsigned char str[6] = " 1:02\0";
    unsigned short s = time.second;

    if(time.hour > 9)   t_itoa(&str[0], time.hour, 10, 0);
    else                t_itoa(&str[1], time.hour, 10, 0);
    str[2] = ':';
    if(time.minute > 9) t_itoa(&str[3], time.minute, 10, 0);
    else                t_itoa(&str[4], time.minute, 10, 0);
    OLED_Char(OLED_MAX_X/2-8,  OLED_MAX_Y/2-11, font_Dot, str[2]);
    OLED_Char(OLED_MAX_X/2-48, OLED_MAX_Y/2-11, font_Dot, str[0]);
    OLED_Char(OLED_MAX_X/2-25, OLED_MAX_Y/2-11, font_Dot, str[1]);
    OLED_Char(OLED_MAX_X/2+9,  OLED_MAX_Y/2-11, font_Dot, str[3]);
    OLED_Char(OLED_MAX_X/2+32, OLED_MAX_Y/2-11, font_Dot, str[4]);
    update_SecCircle(time.second);
    OLED_Update();
    while ((s == time.second) && !(Button_Get())) {
        if (sec100 == 50) { OLED_Char(OLED_MAX_X/2-8, OLED_MAX_Y/2-11, font_Dot, ' '); OLED_Update(); }
        __NOP();
    }
}

/************************* END ****************************/
