/***********************************************************
*                        DCF-clock                         *
*            a tiny DCF controlled digital clock           *
*                                                          *
*           by Frank Goetze  -  www.embedded-os.de         *
************************************************************
* Permission to use, copy, modify, and distribute this     *
* software in source and binary forms and its              *
* documentation for any purpose and without fee is hereby  *
* granted, provided that the above authors notice appear   *
* in all copies and that both that authors notice and this *
* permission notice appear in supporting documentation.    *
*                                                          *
* THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND   *
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT    *
* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY    *
* AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.     *
* IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,  *
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR             *
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,    *
* PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF     *
* USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER *
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN        *
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING           *
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE   *
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY *
* OF SUCH DAMAGE.                                          *
************************************************************
*                     clock_simple.c                       *
*             a simple clock with time & date              *
************************************************************
* Revision-Info:                                           *
*                                                          *
* 1.00a     first alpa-release                             *
*                                                          *
***********************************************************/
#include <samd21.h>

#include "../inc/clock_time.h"
#include "../inc/clock_display.h"
#include "../display/OLED_SSD1306.h"
#include "../BSP/clock_Adafruit_Feather_M0.h"

extern time_t  time;
extern unsigned int sec100;
extern char datetime[16];

static void t_itoa(char *buff, unsigned int value, unsigned int s_div, unsigned char mode)
{
    if ((value / s_div) > 0) { *buff++ = (value / s_div) + '0'; value %= s_div; }
    else if (mode != 0) *buff++ = '0';
    *buff++ = value + '0';
    *buff++ = 0;
}

/*
************************************************************
*                   init the simple clock                  *
************************************************************
*/
void clock_simple_init(void)
{
    OLED_Clear(0);
    OLED_Line(0, DISPLAY_Y, DISPLAY_X, DISPLAY_Y, fgcolor);
}

/*
************************************************************
*              next loop step of simple clock              *
************************************************************
*/
void clock_simple(void)
{
    char str[6] = " 1:02\0";
    char sec[3] = "03\0";
    unsigned short s = time.second;

    if(time.hour > 9)   t_itoa(&str[0], time.hour, 10, 0);
    else                t_itoa(&str[1], time.hour, 10, 0);
    str[2] = ':';
    if(time.minute > 9) t_itoa(&str[3], time.minute, 10, 0);
    else                t_itoa(&str[4], time.minute, 10, 0);
    if(time.second > 9) t_itoa(&sec[0], time.second, 10, 0);
    else                t_itoa(&sec[1], time.second, 10, 0);
    OLED_Text(0, 8, font_Dot, str);
    OLED_Text(96, 14, font_Dot_small, sec);
    OLED_Text(12, 40, font_8_8, datetime);
    OLED_Update();
    while ((s == time.second) && !(Button_Get())) {
        if (sec100 == 50) { OLED_Char(32, 8, font_Dot, ' '); OLED_Update(); }
        __NOP();
    }
}

/************************* END ****************************/
