
/* Includes ------------------------------------------------------------------*/
#include "clock_ascii.h"

static unsigned char const AsciiSlim[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // sp
  0x00, 0x00, 0x00, 0x2f, 0x00, 0x00, // !
  0x00, 0x00, 0x07, 0x00, 0x07, 0x00, // "
  0x00, 0x14, 0x7f, 0x14, 0x7f, 0x14, // #
  0x00, 0x24, 0x2a, 0x7f, 0x2a, 0x12, // $
  0x00, 0x62, 0x64, 0x08, 0x13, 0x23, // %
  0x00, 0x36, 0x49, 0x55, 0x22, 0x50, // &
  0x00, 0x00, 0x05, 0x03, 0x00, 0x00, // '
  0x00, 0x00, 0x1c, 0x22, 0x41, 0x00, // (
  0x00, 0x00, 0x41, 0x22, 0x1c, 0x00, // )
  0x00, 0x14, 0x08, 0x3E, 0x08, 0x14, // *
  0x00, 0x08, 0x08, 0x3E, 0x08, 0x08, // +
  0x00, 0x00, 0x00, 0xA0, 0x60, 0x00, // ,
  0x00, 0x08, 0x08, 0x08, 0x08, 0x08, // -
  0x00, 0x00, 0x60, 0x60, 0x00, 0x00, // .
  0x00, 0x20, 0x10, 0x08, 0x04, 0x02, // /
  0x00, 0x3E, 0x51, 0x49, 0x45, 0x3E, // 0
  0x00, 0x00, 0x42, 0x7F, 0x40, 0x00, // 1
  0x00, 0x42, 0x61, 0x51, 0x49, 0x46, // 2
  0x00, 0x21, 0x41, 0x45, 0x4B, 0x31, // 3
  0x00, 0x18, 0x14, 0x12, 0x7F, 0x10, // 4
  0x00, 0x27, 0x45, 0x45, 0x45, 0x39, // 5
  0x00, 0x3C, 0x4A, 0x49, 0x49, 0x30, // 6
  0x00, 0x01, 0x71, 0x09, 0x05, 0x03, // 7
  0x00, 0x36, 0x49, 0x49, 0x49, 0x36, // 8
  0x00, 0x06, 0x49, 0x49, 0x29, 0x1E, // 9
  0x00, 0x00, 0x36, 0x36, 0x00, 0x00, // :
  0x00, 0x00, 0x56, 0x36, 0x00, 0x00, // ;
  0x00, 0x08, 0x14, 0x22, 0x41, 0x00, // <
  0x00, 0x14, 0x14, 0x14, 0x14, 0x14, // =
  0x00, 0x00, 0x41, 0x22, 0x14, 0x08, // >
  0x00, 0x02, 0x01, 0x51, 0x09, 0x06, // ?
  0x00, 0x32, 0x49, 0x59, 0x51, 0x3E, // @
  0x00, 0x7C, 0x12, 0x11, 0x12, 0x7C, // A
  0x00, 0x7F, 0x49, 0x49, 0x49, 0x36, // B
  0x00, 0x3E, 0x41, 0x41, 0x41, 0x22, // C
  0x00, 0x7F, 0x41, 0x41, 0x22, 0x1C, // D
  0x00, 0x7F, 0x49, 0x49, 0x49, 0x41, // E
  0x00, 0x7F, 0x09, 0x09, 0x09, 0x01, // F
  0x00, 0x3E, 0x41, 0x49, 0x49, 0x7A, // G
  0x00, 0x7F, 0x08, 0x08, 0x08, 0x7F, // H
  0x00, 0x00, 0x41, 0x7F, 0x41, 0x00, // I
  0x00, 0x20, 0x40, 0x41, 0x3F, 0x01, // J
  0x00, 0x7F, 0x08, 0x14, 0x22, 0x41, // K
  0x00, 0x7F, 0x40, 0x40, 0x40, 0x40, // L
  0x00, 0x7F, 0x02, 0x0C, 0x02, 0x7F, // M
  0x00, 0x7F, 0x04, 0x08, 0x10, 0x7F, // N
  0x00, 0x3E, 0x41, 0x41, 0x41, 0x3E, // O
  0x00, 0x7F, 0x09, 0x09, 0x09, 0x06, // P
  0x00, 0x3E, 0x41, 0x51, 0x21, 0x5E, // Q
  0x00, 0x7F, 0x09, 0x19, 0x29, 0x46, // R
  0x00, 0x46, 0x49, 0x49, 0x49, 0x31, // S
  0x00, 0x01, 0x01, 0x7F, 0x01, 0x01, // T
  0x00, 0x3F, 0x40, 0x40, 0x40, 0x3F, // U
  0x00, 0x1F, 0x20, 0x40, 0x20, 0x1F, // V
  0x00, 0x3F, 0x40, 0x38, 0x40, 0x3F, // W
  0x00, 0x63, 0x14, 0x08, 0x14, 0x63, // X
  0x00, 0x07, 0x08, 0x70, 0x08, 0x07, // Y
  0x00, 0x61, 0x51, 0x49, 0x45, 0x43, // Z
  0x00, 0x00, 0x7F, 0x41, 0x41, 0x00, // [
  0x00, 0x55, 0x2A, 0x55, 0x2A, 0x55, // 55
  0x00, 0x00, 0x41, 0x41, 0x7F, 0x00, // ]
  0x00, 0x04, 0x02, 0x01, 0x02, 0x04, // ^
  0x00, 0x40, 0x40, 0x40, 0x40, 0x40, // _
  0x00, 0x00, 0x01, 0x02, 0x04, 0x00, // '
  0x00, 0x20, 0x54, 0x54, 0x54, 0x78, // a
  0x00, 0x7F, 0x48, 0x44, 0x44, 0x38, // b
  0x00, 0x38, 0x44, 0x44, 0x44, 0x20, // c
  0x00, 0x38, 0x44, 0x44, 0x48, 0x7F, // d
  0x00, 0x38, 0x54, 0x54, 0x54, 0x18, // e
  0x00, 0x08, 0x7E, 0x09, 0x01, 0x02, // f
  0x00, 0x18, 0xA4, 0xA4, 0xA4, 0x7C, // g
  0x00, 0x7F, 0x08, 0x04, 0x04, 0x78, // h
  0x00, 0x00, 0x44, 0x7D, 0x40, 0x00, // i
  0x00, 0x40, 0x80, 0x84, 0x7D, 0x00, // j
  0x00, 0x7F, 0x10, 0x28, 0x44, 0x00, // k
  0x00, 0x00, 0x41, 0x7F, 0x40, 0x00, // l
  0x00, 0x7C, 0x04, 0x18, 0x04, 0x78, // m
  0x00, 0x7C, 0x08, 0x04, 0x04, 0x78, // n
  0x00, 0x38, 0x44, 0x44, 0x44, 0x38, // o
  0x00, 0xFC, 0x24, 0x24, 0x24, 0x18, // p
  0x00, 0x18, 0x24, 0x24, 0x18, 0xFC, // q
  0x00, 0x7C, 0x08, 0x04, 0x04, 0x08, // r
  0x00, 0x48, 0x54, 0x54, 0x54, 0x20, // s
  0x00, 0x04, 0x3F, 0x44, 0x40, 0x20, // t
  0x00, 0x3C, 0x40, 0x40, 0x20, 0x7C, // u
  0x00, 0x1C, 0x20, 0x40, 0x20, 0x1C, // v
  0x00, 0x3C, 0x40, 0x30, 0x40, 0x3C, // w
  0x00, 0x44, 0x28, 0x10, 0x28, 0x44, // x
  0x00, 0x1C, 0xA0, 0xA0, 0xA0, 0x7C, // y
  0x00, 0x44, 0x64, 0x54, 0x4C, 0x44, // z
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, // horiz lines
};

/*******************************************************************************
* Function Name  : GetASCIICode
* Description    : 
* Input          : 
* Output         : 
* Return         : None
* Attention		 : None
*******************************************************************************/
void GetASCIICodeS(unsigned char* pBuffer,unsigned char ASCII)
{  
   memcpy(pBuffer,(const void *)(&AsciiSlim[(ASCII - 32) * 6]) , 6);
}



static unsigned char const AsciiSmall[760] = {
//0x08,0x08,0x20,0x5F,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // <space>
0x08,0x08,0x08,0x08,0x08,0x00,0x08,0x00,  // !
0x14,0x14,0x00,0x00,0x00,0x00,0x00,0x00,  // "
0x00,0x24,0x7E,0x24,0x24,0x7E,0x24,0x00,  // #
0x10,0x7C,0x50,0x7C,0x14,0x7C,0x10,0x00,  // $
0x00,0x62,0x64,0x08,0x10,0x26,0x46,0x00,  // %
0x00,0x10,0x28,0x10,0x2A,0x44,0x3A,0x00,  // &
0x00,0x08,0x10,0x00,0x00,0x00,0x00,0x00,  // '
0x00,0x08,0x10,0x10,0x10,0x10,0x08,0x00,  // (
0x00,0x10,0x08,0x08,0x08,0x08,0x10,0x00,  // )
0x00,0x00,0x28,0x10,0x7C,0x10,0x28,0x00,  // *
0x00,0x00,0x10,0x10,0x7C,0x10,0x10,0x00,  // +
0x00,0x00,0x00,0x00,0x00,0x08,0x08,0x10,  // ,
0x00,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,  // -
0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,  // .
0x00,0x00,0x04,0x08,0x10,0x20,0x40,0x00,  // /

0x00,0x78,0x8C,0x94,0xA4,0xC4,0x78,0x00,  // 0
0x00,0x60,0xA0,0x20,0x20,0x20,0xF8,0x00,  // 1
0x00,0x78,0x84,0x04,0x78,0x80,0xFC,0x00,  // 2
0x00,0x78,0x84,0x18,0x04,0x84,0x78,0x00,  // 3
0x00,0x10,0x30,0x50,0x90,0xFC,0x10,0x00,  // 4
0x00,0xFC,0x80,0xF8,0x04,0x84,0x78,0x00,  // 5
0x00,0x78,0x80,0xF8,0x84,0x84,0x78,0x00,  // 6
0x00,0xFC,0x04,0x08,0x10,0x20,0x20,0x00,  // 7
0x00,0x78,0x84,0x78,0x84,0x84,0x78,0x00,  // 8
0x00,0x78,0x84,0x84,0x7C,0x04,0x78,0x00,  // 9
0x00,0x00,0x00,0x10,0x00,0x00,0x10,0x00,  // :
0x00,0x00,0x10,0x00,0x00,0x10,0x10,0x20,  // ;
0x00,0x00,0x08,0x10,0x20,0x10,0x08,0x00,  // <
0x00,0x00,0x00,0x7C,0x00,0x7C,0x00,0x00,  // =
0x00,0x00,0x20,0x10,0x08,0x10,0x20,0x00,  // >
0x00,0x3C,0x42,0x04,0x08,0x00,0x08,0x00,  // ?

0x00,0x3C,0x4A,0x56,0x5E,0x40,0x3C,0x00,  // @
0x00,0x78,0x84,0x84,0xFC,0x84,0x84,0x00,  // A
0x00,0xF8,0x84,0xF8,0x84,0x84,0xF8,0x00,  // B
0x00,0x78,0x84,0x80,0x80,0x84,0x78,0x00,  // C
0x00,0xF0,0x88,0x84,0x84,0x88,0xF0,0x00,  // D
0x00,0xFC,0x80,0xF8,0x80,0x80,0xFC,0x00,  // E
0x00,0xFC,0x80,0xF8,0x80,0x80,0x80,0x00,  // F
0x00,0x78,0x84,0x80,0x9C,0x84,0x78,0x00,  // G
0x00,0x84,0x84,0xFC,0x84,0x84,0x84,0x00,  // H
0x00,0x7C,0x10,0x10,0x10,0x10,0x7C,0x00,  // I
0x00,0x04,0x04,0x04,0x84,0x84,0x78,0x00,  // J
0x00,0x88,0x90,0xE0,0x90,0x88,0x84,0x00,  // K
0x00,0x80,0x80,0x80,0x80,0x80,0xFC,0x00,  // L
0x00,0x84,0xCC,0xB4,0x84,0x84,0x84,0x00,  // M
0x00,0x84,0xC4,0xA4,0x94,0x8C,0x84,0x00,  // N
0x00,0x78,0x84,0x84,0x84,0x84,0x78,0x00,  // O

0x00,0xF8,0x84,0x84,0xF8,0x80,0x80,0x00,  // P
0x00,0x78,0x84,0x84,0xA4,0x94,0x78,0x00,  // Q
0x00,0xF8,0x84,0x84,0xF8,0x88,0x84,0x00,  // R
0x00,0x78,0x80,0x78,0x04,0x84,0x78,0x00,  // S
0x00,0xFE,0x10,0x10,0x10,0x10,0x10,0x00,  // T
0x00,0x84,0x84,0x84,0x84,0x84,0x78,0x00,  // U
0x00,0x84,0x84,0x84,0x84,0x48,0x30,0x00,  // V
0x00,0x84,0x84,0x84,0x84,0xB4,0x48,0x00,  // W
0x00,0x84,0x48,0x30,0x30,0x48,0x84,0x00,  // X
0x00,0x82,0x44,0x28,0x10,0x10,0x10,0x00,  // Y
0x00,0xFC,0x08,0x10,0x20,0x40,0xFC,0x00,  // Z
0x00,0x38,0x20,0x20,0x20,0x20,0x38,0x00,  // [
0x00,0x00,0x40,0x20,0x10,0x08,0x04,0x00,  // <backslash>
0x00,0x38,0x08,0x08,0x08,0x08,0x38,0x00,  // ]
0x00,0x10,0x38,0x54,0x10,0x10,0x10,0x00,  // ^
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,  // _

0x3C,0x42,0x99,0xA1,0xA1,0x99,0x42,0x3C,  // `
0x00,0x00,0x38,0x04,0x3C,0x44,0x3C,0x00,  // a
0x00,0x40,0x40,0x78,0x44,0x44,0x78,0x00,  // b
0x00,0x00,0x1C,0x20,0x20,0x20,0x1C,0x00,  // c
0x00,0x04,0x04,0x3C,0x44,0x44,0x3C,0x00,  // d
0x00,0x00,0x38,0x44,0x78,0x40,0x3C,0x00,  // e
0x00,0x0C,0x10,0x18,0x10,0x10,0x10,0x00,  // f
0x00,0x00,0x3E,0x42,0x42,0x3E,0x02,0x3C,  // g
0x00,0x40,0x40,0x78,0x44,0x44,0x44,0x00,  // h
0x00,0x08,0x00,0x18,0x08,0x08,0x1C,0x00,  // i
0x00,0x04,0x00,0x04,0x04,0x04,0x24,0x18,  // j
0x00,0x40,0x50,0x60,0x60,0x50,0x48,0x00,  // k
0x00,0x10,0x10,0x10,0x10,0x10,0x0C,0x00,  // l
0x00,0x00,0x68,0x54,0x54,0x54,0x54,0x00,  // m
0x00,0x00,0x78,0x44,0x44,0x44,0x44,0x00,  // n
0x00,0x00,0x38,0x44,0x44,0x44,0x38,0x00,  // o

0x00,0x00,0x78,0x44,0x44,0x78,0x40,0x40,  // p
0x00,0x00,0x3C,0x44,0x44,0x3C,0x04,0x06,  // q
0x00,0x00,0x1C,0x20,0x20,0x20,0x20,0x00,  // r
0x00,0x00,0x38,0x40,0x38,0x04,0x78,0x00,  // s
0x00,0x10,0x38,0x10,0x10,0x10,0x0C,0x00,  // t
0x00,0x00,0x44,0x44,0x44,0x44,0x38,0x00,  // u
0x00,0x00,0x44,0x44,0x28,0x28,0x10,0x00,  // v
0x00,0x00,0x44,0x54,0x54,0x54,0x28,0x00,  // w
0x00,0x00,0x44,0x28,0x10,0x28,0x44,0x00,  // x
0x00,0x00,0x44,0x44,0x44,0x3C,0x04,0x38,  // y
0x00,0x00,0x7C,0x08,0x10,0x20,0x7C,0x00,  // z
0x00,0x1C,0x10,0x60,0x10,0x10,0x1C,0x00,  // {
0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x00,  // |
0x00,0x70,0x10,0x0C,0x10,0x10,0x70,0x00,  // }
0x00,0x14,0x28,0x00,0x00,0x00,0x00,0x00,  // ~
};

/*******************************************************************************
* Function Name  : GetASCIICode
* Description    : 
* Input          : 
* Output         : 
* Return         : None
* Attention		 : None
*******************************************************************************/
void GetASCIICode(unsigned char* pBuffer,unsigned char ASCII)
{  
   memcpy(pBuffer,(const void *)(&AsciiSmall[(ASCII - 32) * 8]) , 8);
}



static unsigned char const AsciiDot[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // <space>

0x00,0x00,0x0D,0xB0,0x0D,0xB0,0x00,0x00,0x60,0x06,0x60,0x06,0x00,0x00,0x60,0x06,0x60,0x06,0x00,0x00,0x60,0x06,0x60,0x06,0x00,0x00,0x60,0x06,0x60,0x06,0x00,0x00,0x60,0x06,0x60,0x06,0x00,0x00,0x0D,0xB0,0x0D,0xB0,0x00,0x00,  // 0
0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x0D,0x80,0x0D,0x80,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x0D,0xB0,0x0D,0xB0,0x00,0x00,  // 1
0x00,0x00,0x6D,0xB0,0x6D,0xB0,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x00,0x0D,0xB0,0x0D,0xB0,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x6D,0xB6,0x6D,0xB6,0x00,0x00,  // 2
0x00,0x00,0x6D,0xB0,0x6D,0xB0,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x00,0x0D,0xB0,0x0D,0xB0,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x00,0x6D,0xB0,0x6D,0xB0,0x00,0x00,  // 3
0x00,0x00,0x60,0x06,0x60,0x06,0x00,0x00,0x60,0x06,0x60,0x06,0x00,0x00,0x60,0x06,0x60,0x06,0x00,0x00,0x6D,0xB6,0x6D,0xB6,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x00,  // 4
0x00,0x00,0x6D,0xB6,0x6D,0xB6,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x6D,0xB0,0x6D,0xB0,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x00,0x6D,0xB0,0x6D,0xB0,0x00,0x00,  // 5
0x00,0x00,0x0D,0xB0,0x0D,0xB0,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x6D,0xB0,0x6D,0xB0,0x00,0x00,0x60,0x06,0x60,0x06,0x00,0x00,0x60,0x06,0x60,0x06,0x00,0x00,0x0D,0xB0,0x0D,0xB0,0x00,0x00,  // 6
0x00,0x00,0x6D,0xB6,0x6D,0xB6,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,  // 7
0x00,0x00,0x0D,0xB0,0x0D,0xB0,0x00,0x00,0x60,0x06,0x60,0x06,0x00,0x00,0x60,0x06,0x60,0x06,0x00,0x00,0x0D,0xB0,0x0D,0xB0,0x00,0x00,0x60,0x06,0x60,0x06,0x00,0x00,0x60,0x06,0x60,0x06,0x00,0x00,0x0D,0xB0,0x0D,0xB0,0x00,0x00,  // 8
0x00,0x00,0x0D,0xB0,0x0D,0xB0,0x00,0x00,0x60,0x06,0x60,0x06,0x00,0x00,0x60,0x06,0x60,0x06,0x00,0x00,0x0D,0xB6,0x0D,0xB6,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x00,0x0D,0xB0,0x0D,0xB0,0x00,0x00,  // 9
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // :
};

/*******************************************************************************
* Function Name  : GetASCIICodeD
* Description    : works only for chars of " " and "0..9,:"
* Input          : 
* Output         : 
* Return         : None
* Attention		 : None
*******************************************************************************/
void GetASCIICodeD(unsigned char* pBuffer,unsigned char ASCII)
{
    if ((ASCII != 0x20) && ((ASCII < 0x30)|| (ASCII > 0x3A))) return;
    if (ASCII == 0x20) ASCII = 0;
    else ASCII -= 0x2F;
    memcpy(pBuffer,(const void *)(&AsciiDot[ASCII * 44]) , 44);
}



static unsigned char const Ascii16Seg[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // <space>

0x00,0x00,0x00,0x0F,0xE7,0xF0,0x1F,0xE7,0xF8,0x3F,0xE7,0xFC,0x70,0x00,0x0E,0x70,0x00,0x3E,0x70,0x00,0x7E,0x70,0x00,0x7E,0x70,0x00,0xEE,0x70,0x00,0xEE,0x70,0x01,0xCE,0x70,0x01,0xCE,0x70,0x03,0x8E,0x70,0x03,0x8E,0x70,0x03,0x0E,0x70,0x03,0x0E,0x70,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x0E,0x70,0x40,0x0E,0x70,0xC0,0x0E,0x70,0xC0,0x0E,0x71,0xC0,0x0E,0x73,0x80,0x0E,0x73,0x80,0x0E,0x77,0x00,0x0E,0x77,0x00,0x0E,0x7E,0x00,0x0E,0x7E,0x00,0x0E,0x7C,0x00,0x0E,0x70,0x00,0x0E,0x3F,0xE7,0xFC,0x1F,0xE7,0xF8,0x0F,0xE7,0xF0,0x00,0x00,0x00,  // 0
0x00,0x00,0x00,0x0F,0xE0,0x00,0x1F,0xE0,0x00,0x1F,0xF8,0x00,0x00,0x18,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x18,0x00,0x1F,0xFF,0xF8,0x1F,0xE7,0xF8,0x0F,0xE7,0xF0,0x00,0x00,0x00,  // 1
0x00,0x00,0x00,0x0F,0xE7,0xF0,0x1F,0xE7,0xF8,0x1F,0xE7,0xFC,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x07,0xC3,0xEE,0x1F,0xE7,0xF8,0x1F,0xE7,0xF8,0x7F,0xC3,0xF0,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x3F,0xE7,0xF8,0x1F,0xE7,0xF8,0x0F,0xE7,0xF0,0x00,0x00,0x00,  // 2
0x00,0x00,0x00,0x0F,0xE7,0xF0,0x1F,0xE7,0xF8,0x1F,0xE7,0xFC,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x07,0xC3,0xEE,0x1F,0xE7,0xF8,0x1F,0xE7,0xF8,0x0F,0xC3,0xFE,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x1F,0xE7,0xFC,0x1F,0xE7,0xF8,0x0F,0xE7,0xF0,0x00,0x00,0x00,  // 3
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x04,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x77,0xC3,0xEE,0x1F,0xE7,0xF8,0x1F,0xE7,0xF8,0x0F,0xC3,0xFE,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 4
0x00,0x00,0x00,0x0F,0xE7,0xF0,0x1F,0xE7,0xF8,0x3F,0xE7,0xF8,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x77,0xC3,0xE0,0x1F,0xE7,0xF8,0x1F,0xE7,0xF8,0x0F,0xC3,0xFE,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x1F,0xE7,0xFC,0x1F,0xE7,0xF8,0x0F,0xE7,0xF0,0x00,0x00,0x00,  // 5
0x00,0x00,0x00,0x0F,0xE7,0xF0,0x1F,0xE7,0xF8,0x3F,0xE7,0xF8,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x77,0xC3,0xE0,0x1F,0xE7,0xF8,0x1F,0xE7,0xF8,0x7F,0xC3,0xFE,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x3F,0xE7,0xFC,0x1F,0xE7,0xF8,0x0F,0xE7,0xF0,0x00,0x00,0x00,  // 6
0x00,0x00,0x00,0x0F,0xE7,0xF0,0x1F,0xE7,0xF8,0x1F,0xE7,0xFC,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 7
0x00,0x00,0x00,0x0F,0xE7,0xF0,0x1F,0xE7,0xF8,0x3F,0xE7,0xFC,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x77,0xC3,0xEE,0x1F,0xE7,0xF8,0x1F,0xE7,0xF8,0x7F,0xC3,0xFE,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x3F,0xE7,0xFC,0x1F,0xE7,0xF8,0x0F,0xE7,0xF0,0x00,0x00,0x00,  // 8
0x00,0x00,0x00,0x0F,0xE7,0xF0,0x1F,0xE7,0xF8,0x3F,0xE7,0xFC,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x70,0x00,0x0E,0x77,0xC3,0xEE,0x1F,0xE7,0xF8,0x1F,0xE7,0xF8,0x0F,0xC3,0xFE,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x1F,0xE7,0xFC,0x1F,0xE7,0xF8,0x0F,0xE7,0xF0,0x00,0x00,0x00,  // 9
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x3C,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x3C,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // :
};

/*******************************************************************************
* Function Name  : GetASCIICode16
* Description    : works only for chars of " " and "0..9,:"
* Input          : 
* Output         : 
* Return         : None
* Attention		 : None
*******************************************************************************/
void GetASCIICode16(unsigned char* pBuffer,unsigned char ASCII)
{
    if ((ASCII != 0x20) && ((ASCII < 0x30)|| (ASCII > 0x3A))) return;
    if (ASCII == 0x20) ASCII = 0;
    else ASCII -= 0x2F;
    memcpy(pBuffer,(const void *)(&Ascii16Seg[ASCII * 3*36]) , 3*36);
}


/*********************************************************************************************************
      END FILE
*********************************************************************************************************/

